import os
import numpy as np
import torchvision
import torch
from torchvision import transforms
from torch.utils.data.dataloader import DataLoader
from torch.utils.data.sampler import SubsetRandomSampler
from torch.utils.data import random_split
import warnings


def get_dataloaders_cifar_c(settings):
    # Prepare dataset
    test_transform = transforms.Compose(
        [
            transforms.ToTensor(),
            transforms.Normalize((0.4914, 0.4822, 0.4465), (0.2023, 0.1994, 0.2010)),
        ]
    )

    dataset_location_id = os.path.join(settings.datasets_path, settings.dataset)

    print("Test on " + settings.corruption_type)
    test_data = torchvision.datasets.CIFAR100(
        root=dataset_location_id, train=False, transform=test_transform, download=False
    )
    test_data.data = np.load(
        dataset_location_id + "/CIFAR-100-C/%s.npy" % settings.corruption_type
    )
    test_data.targets = torch.LongTensor(
        np.load(dataset_location_id + "/CIFAR-100-C/labels.npy")
    )
    test_loader = torch.utils.data.DataLoader(
        test_data,
        batch_size=settings.batch_size,
        shuffle=False,
        num_workers=4,
        pin_memory=True,
    )

    return test_loader
